/* ============ */
/* setchisq.c	*/
/* ============ */
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <mconf.h>
#include <miscdefs.h>
#include <freqdefs.h>

#define	ACT(X)	#X

#define	CLAMP(Out, Var, Lo, Hi)	Out = __min(Hi, __max(Lo, Var))

#define	NEED_ALL(Label)	"\nEnter "Label

#define	NEED_USER_ENTRY(LABEL, LO, HI) \
	NEED_ALL(LABEL" ["ACT(LO)"-"ACT(HI)"]: ")

#define	ELEMS_LABEL	"Number of Categories in Sample Space"
#define	EXPECT_LABEL	"Expected No. Events for Each Category"

#define	REPORT_USER_INT_ENTRY(Entry, Label)		\
    {							\
	fflush(NULL); printf("\n");			\
	printf("\tNumber Entered:  %.f", (double)Entry);\
	printf(" (%s)\n", Label);			\
    }
#define	SET_TWO_POW(Val)				\
    {							\
	UINT	TwoPow = MIN_ELEMS;			\
	while (TwoPow < Val)				\
	{						\
	    TwoPow <<= 1;				\
	}						\
	if (Val < (TwoPow - (TwoPow >> 2))) 		\
	{						\
	    Val = TwoPow >> 1;				\
	}						\
	else						\
	{						\
	    Val = TwoPow;				\
	}						\
    }
#define	SHOW_INT_VALUE_USED(Entered, Used) 			\
	printf("\tTest Value Used: %.f%s\n", (double)Used,	\
	((double)Entered == (double)Used) ? "" : " (Clamped)")

/* ==================================================================== */
/* SetChiSqControls - Puts Run-Control Parameters in CHISQ_STRU		*/
/* ==================================================================== */
void
SetChiSqControls(CHISQ_STRU *ChiSqData)
{
    int     NewlineCh;
    int     UserIntEntry;
    UINT    UserUintEntry;

    NewlineCh = _isatty(_fileno(stdin)) ? '\r' : '\n';

    fflush(NULL);fprintf(stderr, "%c", NewlineCh);
    /* ------------------------------------------------------------- */
    /* Get Number of Elements in Sample Space (Number of Categories) */
    /* ------------------------------------------------------------- */
    GetUint(NEED_USER_ENTRY(ELEMS_LABEL, MIN_ELEMS, MAX_ELEMS),
	&UserUintEntry);

    REPORT_USER_INT_ENTRY(UserUintEntry, ELEMS_LABEL);

    CLAMP(ChiSqData->NumElements, UserUintEntry,
	(UINT)MIN_ELEMS, (UINT)MAX_ELEMS);

    /* ---------------------------------------- */
    /* Get Nearest Power of Two to User's Input */
    /* ---------------------------------------- */
    SET_TWO_POW(ChiSqData->NumElements);
    SHOW_INT_VALUE_USED(UserUintEntry, ChiSqData->NumElements);

   /* ------------------------ */
   /* Set Category Expectation */
   /* ------------------------ */
    fflush(NULL);fprintf(stderr, "%c", NewlineCh);
    GetInt(NEED_USER_ENTRY(EXPECT_LABEL, MIN_EXPECT, MAX_EXPECT),
	&UserIntEntry);

    REPORT_USER_INT_ENTRY(UserIntEntry, EXPECT_LABEL);

    CLAMP(ChiSqData->CellExpect, UserIntEntry, MIN_EXPECT, MAX_EXPECT);

    SHOW_INT_VALUE_USED(UserIntEntry, ChiSqData->CellExpect);

    /* ------------------------------------------------------------ */
    /* Calculate Number of Variates Required to Achieve Expectation */
    /* ------------------------------------------------------------ */
    ChiSqData->NumVariates =
	((ULONG)ChiSqData->CellExpect * (ULONG)ChiSqData->NumElements);

    P(printf("NumVariates = %.f\n", (double)ChiSqData->NumVariates));

    fflush(NULL);fprintf(stderr, "%c", NewlineCh);
}
